#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Raymarching - Apollonian FractalMod01.fsh  by  SardineMilk   
//https://www.shadertoy.com/view/lcsXRM
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float FOV = 1000.;


vec3 palette( float t) {
    vec3 a = vec3(0.5, 0.5, 0.5);
    vec3 b = vec3(0.5, 0.5, 0.5);
    vec3 c = vec3(1.0, 1.0, 1.0);
    vec3 d = vec3(0.263, 0.416, 0.557);

    return a + b*cos( 6.28318*(c*t*d) );
    }


float apollonianSDF( vec3 p ) {
    float width = 1.5f;  // 1.5f
    float s = 3.0f, e;
    for ( int i = 0; i++ < 12; ) {
        p = mod(p - 1.0f, 2.0f ) - 1.0f;
        s *= e = width / dot( p, p );
        p *= e;
    }
    return length( p.yz ) / s;
}


// Calculate the Signed Distance Field for the scene

vec2 map(vec3 point) {
    return vec2(apollonianSDF(point), 1.);
}


vec4 rayMarch(vec3 point, vec3 direction, out int iter) {
    vec2 signedDistance;
    vec4 result;
    
    const int maxMarchingSteps = 2500;  // Maximum number of times ray is marched until loop breaks
    const float maxDistance = 1000.0;  // Maximum distance to object for a miss
    const float minDistance = 0.0001;  // Minimum distance to object for a hit
    
    vec3 rayPosition = point;
    
    for (int i = 0; i < maxMarchingSteps; i++)  // March the ray forwards  
    {        
        // Distance to nearest object
        vec2 signedDistance = map(rayPosition);

        rayPosition += direction * signedDistance.x;  // Move the ray
        
        result = vec4(rayPosition, 0.0);
        if (signedDistance.x > maxDistance) break;  // If the ray misses
        if (signedDistance.x < minDistance) {
            result = vec4(rayPosition, signedDistance.y);
            break;  // If the ray hits something
            }
        iter = i;
    }
    
    
    
    return result;
}


// Default colour for a miss
vec3 col = vec3(0., 0., 0.);
//void mainImage( out vec4 fragColor, in vec2 fragCoord ){
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{

    // Normalized pixel coordinates (from 0 to 1)
    // Shifted so (0, 0) is the centre rather than bottom-left
    vec2 shiftedCoord = fragCoord - (iResolution.xy / 2.0);
    vec2 uv = shiftedCoord / iResolution.y;   
    
    vec3 rayPosition = vec3(uv.x/100., uv.y/100., 0.0);
    vec3 rayDirection = vec3(0.0, 0.0, 1.0);
    rayDirection.xy = uv.xy * atan(radians(FOV));
    rayDirection = normalize(rayDirection);
    
    rayPosition += vec3(1., 1., iTime+1.);
    
    int iterations;
    vec4 hitPosID = rayMarch(rayPosition, rayDirection, iterations);
    vec3 hitPosition = hitPosID.xyz;
    float objectID = hitPosID.w;
    
    // If the ray hit, calculate lighting
    if (objectID != 0.0) {
        col = palette(length(hitPosition));
        col /= vec3(float(iterations)*.5);
        col *= 2.;
        

    }
    
    // Gamma correction
    float gamma = 2.2;
    col = pow(col, vec3(1.0 / gamma));
    // Output to screen
    fragColor = vec4(col,1.0);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

